<?php
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();

/**
 * Stream a CSV for a query (role-safe).
 */
function stream_csv_query(PDO $pdo, string $sql, array $params, array $cols, string $downloadName) {
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="'.$downloadName.'"');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  header('Pragma: no-cache');

  echo "\xEF\xBB\xBF";

  $out = fopen('php://output', 'w');
  fputcsv($out, $cols);

  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);

  while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $line = [];
    foreach ($cols as $c) { $line[] = isset($row[$c]) ? $row[$c] : ''; }
    fputcsv($out, $line);
  }
  fclose($out);
  exit;
}

$action = $_GET['action'] ?? '';
$table  = $_GET['table']  ?? '';

if ($action === 'csv') {
  $maps = [
    // Expanded columns to include the new schema fields
    'companies' => ['id','country','language','company_name','sector','website','ceo_name','MF','job','linkedIn','general_email','hq_city','email','wrong','status','grupo','comment','last_date','last_template','history','initials','private'],
    'templates' => ['id','ref','title1','title2','title3','body','language'],
    'log'       => ['id','id_companies','id_templates','ref','language','title_nr','timestamp'],
  ];
  if (!isset($maps[$table])) {
    http_response_code(400);
    echo "Unknown table.";
    exit;
  }

  $cols = $maps[$table];
  $fname = $table.'_'.date('Ymd').'.csv';

  if ($table === 'companies') {
    [$visWhere, $visParams] = companies_visibility_where('c');
    $quoted = array_map(fn($c)=>"`$c`", $cols);
    $sql = "SELECT ".implode(',', $quoted)." FROM companies c WHERE {$visWhere} ORDER BY c.id ASC";
    stream_csv_query($pdo, $sql, $visParams, $cols, $fname);
  }

  if ($table === 'log') {
    [$visWhere, $visParams] = companies_visibility_where('c');
    $quoted = array_map(fn($c)=>"l.`$c`", $cols);
    // id_companies/id_templates/ref/language/title_nr/timestamp are in l; visibility comes from joined companies
    $sql = "
      SELECT l.id, l.id_companies, l.id_templates, l.ref, l.language, l.title_nr, l.timestamp
      FROM log l
      JOIN companies c ON c.id = l.id_companies
      WHERE {$visWhere}
      ORDER BY l.id ASC
    ";
    stream_csv_query($pdo, $sql, $visParams, $cols, $fname);
  }

  // templates is not visibility-restricted by spec
  if ($table === 'templates') {
    $quoted = array_map(fn($c)=>"`$c`", $cols);
    $sql = "SELECT ".implode(',', $quoted)." FROM templates ORDER BY id ASC";
    stream_csv_query($pdo, $sql, [], $cols, $fname);
  }
}

include __DIR__ . '/header.php';
?>
<section>
  <h2>Export CSV</h2>

  <div class="card">
    <p>Click to download a CSV snapshot of each table.</p>
    <div class="stats">
      <a class="btn" href="export?action=csv&table=companies">Export companies.csv</a>
      <a class="btn" href="export?action=csv&table=templates">Export templates.csv</a>
      <a class="btn" href="export?action=csv&table=log">Export log.csv</a>
    </div>
    <p class="note">CSV is UTF-8 with header row; fields are properly quoted. Companies/log export respects your role visibility.</p>
  </div>
</section>
<?php include __DIR__ . '/footer.php'; ?>
