<?php
require_once __DIR__ . '/includes/auth.php';

$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?? '';
$base = basename($path);                 // e.g. "list.php"
$CURRENT = $base !== '' ? $base : 'list.php';

$PUBLIC = ['login.php', 'logout.php'];
if (!in_array($CURRENT, $PUBLIC, true)) {
  require_login();
}

$me = current_user();

function nav_item(string $file, string $label, string $current): void {
  $active = ($file === $current) ? 'active' : '';
  echo '<a class="' . $active . '" href="' . htmlspecialchars($file) . '">' . htmlspecialchars($label) . '</a>';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Top mail</title>
  <link rel="stylesheet" href="includes/ceo.css?v=3">
  <script defer src="includes/app.js?v=3"></script>
</head>
<body>

  <!-- Force a robust layout even if CSS changes: left group + right group -->
  <div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:14px;">
    <div class="topbar-left" style="display:flex;align-items:center;gap:14px;min-width:0;">
      <div class="brand">Top mail</div>

      <?php if ($me): ?>
        <nav class="menu" style="display:flex;align-items:center;gap:10px;flex-wrap:wrap;">
          <?php nav_item('list.php',      'list',      $CURRENT); ?>
          <?php nav_item('templates.php', 'templates', $CURRENT); ?>

          <?php if (($me['role'] ?? '') === 'admin'): ?>
            <?php nav_item('log.php', 'log', $CURRENT); ?>
          <?php endif; ?>

          <?php nav_item('import.php', 'import', $CURRENT); ?>
          <?php nav_item('export.php', 'export', $CURRENT); ?>

          <?php if (($me['role'] ?? '') === 'admin'): ?>
            <?php nav_item('users.php', 'users', $CURRENT); ?>
          <?php endif; ?>
        </nav>
      <?php endif; ?>
    </div>

    <div class="topbar-right" style="display:flex;align-items:center;gap:10px;flex-shrink:0;">
      <?php if ($me): ?>
        <div class="userbox" title="Signed in" style="display:flex;align-items:center;gap:10px;">
          <span class="userbox__who"><?= htmlspecialchars(($me['initials'] ?? '') . ' — ' . ($me['role'] ?? '')) ?></span>
          <a class="btn small ghost" href="logout.php">logout</a>
        </div>
      <?php endif; ?>

      <button id="themeToggle" class="btn tiny theme-toggle" title="toggle background"></button>
    </div>
  </div>

  <main class="container">
