<?php
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();

$me = current_user();
$myInitials = (string)($me['initials'] ?? '');

[$visWhere, $visParams] = companies_visibility_where('c');
$stmtCnt = $pdo->prepare("SELECT COUNT(*) FROM companies c WHERE {$visWhere}");
$stmtCnt->execute($visParams);
$beforeCount = (int)$stmtCnt->fetchColumn();

$afterCount = $beforeCount;
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv'])) {
  if (is_uploaded_file($_FILES['csv']['tmp_name'])) {
    $fh = fopen($_FILES['csv']['tmp_name'], 'r');
    if ($fh) {
      $wanted = ['country','language','company_name','sector','website','ceo_name','MF','linkedIn','general_email','hq_city','email','comment'];
      $header = fgetcsv($fh); $map = [];
      foreach ((array)$header as $i => $h) {
        $key = strtolower(trim((string)$h));
        if (in_array($key, array_map('strtolower',$wanted), true)) $map[$key] = $i;
      }

      $placeholders = implode(',', array_map(fn($k)=>":$k",$wanted));
      $sql = "INSERT INTO companies (".implode(',',$wanted).", last_date, last_template, history, initials, private)
              VALUES ($placeholders, NULL, NULL, NULL, :initials, 0)";
      $stmt = $pdo->prepare($sql);

      $pdo->beginTransaction();
      $n = 0;
      while (($row = fgetcsv($fh)) !== false) {
        $vals=[];
        foreach ($wanted as $k) {
          $idx = $map[strtolower($k)] ?? null;
          $vals[":$k"] = $idx!==null ? ($row[$idx] ?? null) : null;
        }
        $vals[':initials'] = $myInitials;
        $stmt->execute($vals);
        $n++;
      }
      $pdo->commit();
      fclose($fh);

      $stmtCnt2 = $pdo->prepare("SELECT COUNT(*) FROM companies c WHERE {$visWhere}");
      $stmtCnt2->execute($visParams);
      $afterCount = (int)$stmtCnt2->fetchColumn();

      $message = "Imported $n rows.";
    } else { $message = "Could not open file."; }
  } else { $message = "Upload error."; }
}

include __DIR__ . '/header.php';
?>
<section>
  <h2>Import CSV</h2>
  <form method="post" enctype="multipart/form-data" class="card">
    <label>Choose CSV
      <input type="file" name="csv" accept=".csv,text/csv" required />
    </label>
    <button class="btn primary">upload</button>
  </form>

  <div class="stats">
    <div>Initial rows (visible): <strong><?= $beforeCount; ?></strong></div>
    <div>Final rows (visible): <strong><?= $afterCount; ?></strong></div>
  </div>
  <?php if ($message): ?><p class="note"><?= htmlspecialchars($message); ?></p><?php endif; ?>
  <details>
    <summary>Expected columns</summary>
    <pre>country, language, company_name, sector, website, ceo_name, MF, linkedIn, general_email, hq_city, email, comment</pre>
  </details>
</section>
<?php include __DIR__ . '/footer.php'; ?>
