<?php
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();

[$visWhere, $visParams] = companies_visibility_where('c');

// last visible log entry for "Goto record"
$stmtLast = $pdo->prepare("
  SELECT l.id_companies
  FROM log l
  JOIN companies c ON c.id = l.id_companies
  WHERE {$visWhere}
  ORDER BY l.timestamp DESC, l.id DESC
  LIMIT 1
");
$stmtLast->execute($visParams);
$lastId = $stmtLast->fetchColumn();

$stmt = $pdo->prepare("
  SELECT l.*, c.company_name
  FROM log l
  LEFT JOIN companies c ON c.id = l.id_companies
  WHERE {$visWhere}
  ORDER BY l.timestamp DESC, l.id DESC
  LIMIT 1000
");
$stmt->execute($visParams);
$rows = $stmt->fetchAll();

include __DIR__ . '/header.php';
?>
<section>
  <h2>Log</h2>
  <div class="toolbar" style="margin-top:0">
    <?php if ($lastId): ?>
      <a class="btn primary" href="list?highlight_id=<?= (int)$lastId; ?>">Goto record</a>
    <?php endif; ?>
  </div>
  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>id</th><th>company</th><th>id_companies</th><th>ref</th><th>id_templates</th><th>language</th><th>title_nr</th><th>timestamp</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id']; ?></td>
            <td><?= htmlspecialchars($r['company_name'] ?? ''); ?></td>
            <td><?= (int)$r['id_companies']; ?></td>
            <td><?= htmlspecialchars($r['ref'] ?? ''); ?></td>
            <td><?= (int)$r['id_templates']; ?></td>
            <td><?= htmlspecialchars($r['language'] ?? ''); ?></td>
            <td><?= (int)$r['title_nr']; ?></td>
            <td><?= htmlspecialchars($r['timestamp']); ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</section>
<?php include __DIR__ . '/footer.php'; ?>
