<?php
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();

// Handle POST save/delete
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  if ($action === 'save') {
    $id        = (int)($_POST['id'] ?? 0);
    $language  = trim($_POST['language'] ?? '');
    $ref       = trim($_POST['ref'] ?? '');
    $title1    = trim($_POST['title1'] ?? '');
    $title2    = trim($_POST['title2'] ?? '');
    $title3    = trim($_POST['title3'] ?? '');
    $body      = trim($_POST['body'] ?? '');

    if ($id > 0) {
      $sql = "UPDATE templates SET language=:language, ref=:ref, title1=:title1, title2=:title2, title3=:title3, body=:body WHERE id=:id";
      $pdo->prepare($sql)->execute([
        ':language'=>$language, ':ref'=>$ref, ':title1'=>$title1, ':title2'=>$title2,
        ':title3'=>$title3, ':body'=>$body, ':id'=>$id
      ]);
    } else {
      $sql = "INSERT INTO templates (language, ref, title1, title2, title3, body) VALUES (:language,:ref,:title1,:title2,:title3,:body)";
      $pdo->prepare($sql)->execute([
        ':language'=>$language, ':ref'=>$ref, ':title1'=>$title1, ':title2'=>$title2,
        ':title3'=>$title3, ':body'=>$body
      ]);
    }
    header('Location: templates'); exit;
  }
  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) $pdo->prepare("DELETE FROM templates WHERE id=:id")->execute([':id'=>$id]);
    header('Location: templates'); exit;
  }
}

// Load templates
$rows = $pdo->query("SELECT * FROM templates ORDER BY id ASC")->fetchAll();
include __DIR__ . '/header.php';
?>
<section>
  <div class="toolbar">
    <div class="brand" style="opacity:.75">templates</div>
  </div>

  <div class="tpl-card">
    <form action="templates" method="post" class="tpl-form" autocomplete="off">
      <input type="hidden" name="action" value="save">
      <div class="tpl-grid tpl-grid--v2">
        <div class="cell cell-id">
          <label>ID</label>
          <input type="text" name="id" value="" placeholder="(auto)" readonly>
        </div>
        <div class="cell cell-title1">
          <label>Title 1</label>
          <input type="text" name="title1" value="">
        </div>
        <div class="cell cell-body">
          <label>Body</label>
          <textarea name="body" rows="6" class="mono"></textarea>
        </div>

        <div class="cell cell-language">
          <label>Language</label>
          <input type="text" name="language" value="" maxlength="5" placeholder="en, fr...">
        </div>
        <div class="cell cell-title2">
          <label>Title 2</label>
          <input type="text" name="title2" value="">
        </div>

        <div class="cell cell-ref">
          <label>Ref</label>
          <input type="text" name="ref" value="" placeholder="e.g., introA">
        </div>
        <div class="cell cell-title3">
          <label>Title 3</label>
          <input type="text" name="title3" value="">
        </div>
      </div>
      <div class="tpl-actions">
        <button class="btn primary">save</button>
      </div>
    </form>
  </div>

  <?php foreach ($rows as $t): ?>
    <div class="tpl-card">
      <form action="templates" method="post" class="tpl-form" autocomplete="off">
        <input type="hidden" name="action" value="save">
        <div class="tpl-grid tpl-grid--v2">
          <div class="cell cell-id">
            <label>ID</label>
            <input type="text" name="id" value="<?= htmlspecialchars($t['id']) ?>" readonly>
          </div>
          <div class="cell cell-title1">
            <label>Title 1</label>
            <input type="text" name="title1" value="<?= htmlspecialchars($t['title1'] ?? '') ?>">
          </div>
          <div class="cell cell-body">
            <label>Body</label>
            <textarea name="body" rows="6" class="mono"><?= htmlspecialchars($t['body'] ?? '') ?></textarea>
          </div>

          <div class="cell cell-language">
            <label>Language</label>
            <input type="text" name="language" value="<?= htmlspecialchars($t['language'] ?? '') ?>" maxlength="5">
          </div>
          <div class="cell cell-title2">
            <label>Title 2</label>
            <input type="text" name="title2" value="<?= htmlspecialchars($t['title2'] ?? '') ?>">
          </div>

          <div class="cell cell-ref">
            <label>Ref</label>
            <input type="text" name="ref" value="<?= htmlspecialchars($t['ref'] ?? '') ?>">
          </div>
          <div class="cell cell-title3">
            <label>Title 3</label>
            <input type="text" name="title3" value="<?= htmlspecialchars($t['title3'] ?? '') ?>">
          </div>
        </div>

        <div class="tpl-actions">
          <button class="btn primary">save</button>
          <button class="btn danger" name="action" value="delete" onclick="return confirm('Delete this template?');">delete</button>
        </div>
      </form>
    </div>
  <?php endforeach; ?>
</section>
<?php include __DIR__ . '/footer.php'; ?>
